let Generators = {
    GenerateEmployee: (gender, employeeTypeName, settings, level) => {
        let name = chance.name({gender: gender});

        let speed = 0;
        let werMultiplier = 1;
        switch (level) {
            case EmployeeLevels.Beginner:
                speed = _.random(80, 150);
                werMultiplier = 1;
                break;
            case EmployeeLevels.Intermediate:
                speed = _.random(100, 250);
                werMultiplier = 15;
                break;
            case EmployeeLevels.Expert:
                speed = _.random(150, 400);
                werMultiplier = 20;
                break;
        }

        let requiredWer = parseInt(speed * 0.02) * Object.keys(EmployeeLevels).indexOf(level) + 1;

        let salary = Helpers.CalculateBaseSalary(employeeTypeName, level, speed);
        salary = Math.round(_.random(salary * 0.9, salary * 1.3));

        let startHour = _.random(7, 9);
        let startMinute = _.random(0, 59);

        return employee = {
            id: chance.guid(),
            name: name,
            originalName: name,
            employeeTypeName: employeeTypeName,
            salary: salary,
            avatar: gender.toLowerCase() + _.random(1, 4),
            progress: 0,
            level: level,
            employees: [],
            speed: speed,
            animationSpeed: parseFloat(_.random(1, 4, true).toFixed(1)),
            requiredWer: requiredWer,
            mood: 100,
            overtimeMinutes: 0,
            components: [],
            gender: gender,
            hoursLeft: 24,
            callInSickDaysLeft: Helpers.RandomizeNumber(Configuration.InitialCallInSickDaysLeft, 40),
            sickHoursLeft: 0,

            workingHours: {
                start: {hour: startHour, minute: startMinute},
                end: {hour: startHour + 8, minute: startMinute}
            },
            newWorkingHours: {
                start: {hour: startHour, minute: startMinute},
                end: {hour: startHour + 8, minute: startMinute}
            }
        };
    },
    GenerateContract: (contractType, size, employeeLevel) => {
        let $rootScope = GetRootScope();
        let product = _.sample(CompetitorProducts);

        let contract = {
            id: chance.guid(),
            number: $rootScope.settings.contracts.length + 1,
            productId: product.id,
            urgency: _.sample(Priorities),
            requirements: {},
            status: ContractStatuses.NotSet,
            offers: [],
            completed: false
        };

        let companyTier = $rootScope.companyTier;
        contract.type = ContractTypes.FixedPrice;

        let companyComponents = [];

        let productType = ProductTypes.find(x => x.name == product.productTypeName);

        productType.features.forEach(featureName => {
            let feature = Features.find(x => x.name == featureName);
            Object.keys(feature.requirements).forEach(componentName => {
                let component = Components.find(x => x.name == componentName);
                if (component.type == ComponentTypes.Component) {
                    companyComponents.push(component);
                } else {
                    companyComponents = _.union(companyComponents, Helpers.GetRequiredComponentsForProduction(component));
                }
            });
        });

        let employeeLevelsToInclude = [EmployeeLevels.Beginner];
        switch (employeeLevel) {
            case EmployeeLevels.Intermediate:
                employeeLevelsToInclude.push(EmployeeLevels.Intermediate);
                break;
            case EmployeeLevels.Expert:
                employeeLevelsToInclude.push(EmployeeLevels.Intermediate);
                employeeLevelsToInclude.push(EmployeeLevels.Expert);
                break;
        }

        companyComponents = _.uniq(companyComponents).filter(x => employeeLevelsToInclude.includes(x.employeeLevel));

        // Limit to components if LeadDev is not unlocked
        let leadDeveloper = EmployeeTypes.find(x => x.name == EmployeeTypeNames.LeadDeveloper);
        if (companyTier < leadDeveloper.tier) {
            companyComponents = companyComponents.filter(x => x.type == ComponentTypes.Component)
        }

        // Limit to non-graphics if designer is not unlocked
        let designer = EmployeeTypes.find(x => x.name == EmployeeTypeNames.Designer);
        if (companyTier < designer.tier) {
            companyComponents = companyComponents.filter(x => x.employeeTypeName != EmployeeTypeNames.Designer)
        }

        // Limit components to ones we have researched
        let availableComponentsInOrganization = _.uniq(_.flatten(Helpers.GetAllEmployees().map(x => x.components)));
        let missingComponents = companyComponents.filter(x => !availableComponentsInOrganization.some(c => c.name == x.name));
        companyComponents = companyComponents.filter(x => !missingComponents.some(c => c.name == x.name));

        // Randomly (50% chance) add a missing component to the requirement, or none of the above matched
        if (missingComponents.length > 0 && (_.random(1, 2) == 1 || companyComponents.length == 0)) {
            companyComponents.push(_.sample(missingComponents));
        }

        // Define Type
        let jobTypes = [ContractTypes.FixedPrice];
        if (companyTier >= 5) {
            jobTypes.push(ContractTypes.LimitedRFQ);
        }

        contract.type = _.sample(jobTypes);
        contract.chargeableHours = 0;

        if (contractType != null && contractType != "") {
            contract.type = contractType;
        }

        // Define size
        let targetHours = Math.max(_.random($rootScope.settings.maxContractHours * 0.5, $rootScope.settings.maxContractHours), 5);

        if (size != null) {
            switch (size) {
                case "Small":
                    targetHours = $rootScope.settings.maxContractHours * 0.3;
                    break;
                case "Medium":
                    targetHours = $rootScope.settings.maxContractHours * 0.6;
                    break;
                case "Large":
                    targetHours = $rootScope.settings.maxContractHours;
                    break;
            }
        }

        contract.requirements = {};
        do {
            let component = _.sample(companyComponents);
            contract.requirements[component.name] = (contract.requirements[component.name] || 0) + 1;

            contract.chargeableHours = _.sum(Object.keys(contract.requirements).map(componentName => {
                let requirementComponent = Components.find(x => x.name == componentName);
                return Helpers.CalculateComponentProductionHours(requirementComponent) * contract.requirements[componentName];
            }));
        } while (contract.chargeableHours < targetHours);

        let deadlineHours = 24 * ((100 + contract.chargeableHours) / 100);
        let pricePerHour = 0;
        let offerHours = 0;


        switch (contract.urgency) {
            case Priorities.Low:
                deadlineHours *= 2;
                offerHours = 100;
                pricePerHour = 120;
                break;
            case Priorities.Medium:
                offerHours = 48;
                pricePerHour = 200;
                break;
            case Priorities.High:
                deadlineHours *= 0.7;
                offerHours = 24;
                pricePerHour = 330;
                break;
        }

        // Minimum 24 hours
        deadlineHours = Math.max(Math.round(deadlineHours), 24);

        contract.deadlineHours = deadlineHours;
        contract.hoursLeft = contract.deadlineHours;
        contract.offerHours = offerHours;
        contract.offerHoursLeft = offerHours;
        contract.pricePerHour = pricePerHour;
        contract.price = contract.chargeableHours * contract.pricePerHour;

        return contract;
    },
    GenerateContractCompetitorOffer: job => {
        let competitor = _.sample(Database.competitors);

        let initialPrice = job.chargeableHours * job.pricePerHour;
        initialPrice = initialPrice * _.random(competitor.competitiveness, competitor.competitiveness * 1.3);

        let deadlineHours = job.deadlineHours;

        let offer = {
            name: competitor.name,
            price: Math.round(initialPrice),
            deadlineHours: deadlineHours,
            competitor: true
        };

        return offer;
    },
    GenerateCandidates: () => {
        let $rootScope = GetRootScope();
        let candidates = [];

        _.toArray(EmployeeTypeNames).forEach(employeeType => {
            let wer = 0;
            for (let i = 0; i < 60; i++) {
                wer += 1;
                let candidateWer = wer;
                let level;
                if (_.inRange(i, 0, 20)) {
                    level = EmployeeLevels.Beginner;
                }
                if (_.inRange(i, 20, 40)) {
                    level = EmployeeLevels.Intermediate;
                    candidateWer += _.random(10, 20);
                }
                if (_.inRange(i, 40, 60)) {
                    level = EmployeeLevels.Expert;
                    candidateWer = _.random(20, 30);
                }

                let candidate = Generators.GenerateEmployee(chance.gender(), employeeType, $rootScope.settings, level, candidateWer);
                candidate.headhunted = false;
                candidates.push(candidate);
            }
        });

        return candidates;
    }
};
